#######################################################################
# Use this script to create executables for the demo scripts with PL/SQL
# blocks embedded in C code.  To create all executables, at the prompt type:
# % make -f demo_plsql.mk demos
# This will create four executables: pls_examp9, pls_examp10, pls_sample5, pls_sample6.
# Each of these executables can be run by typing the executable name on
# the command line.
# Read Appendix B in the PL/SQL User Guide and Reference, entitled "Sample
# Programs" for details on running the .sql scripts.
#######################################################################

include $(ORACLE_HOME)/plsql/lib/env_plsql.mk

.SUFFIXES: .pc .c .o

DEMO_MAKEFILE= $(ORACLE_HOME)/plsql/demo/demo_plsql.mk
EXTP_MAKEFILE= $(ORACLE_HOME)/rdbms/demo/demo_rdbms.mk
USERID=scott/tiger
PROCPLSFLAGS= sqlcheck=full userid=$(USERID) CHAR_MAP=VARCHAR2, DBMS=V7

PCDEMOS= pls_examp10 pls_examp9 pls_sample5 pls_sample6

BUILDSCRIPT= pls_exampbld
LOADSCRIPT= pls_examplod

demos: $(PCDEMOS) extproc.so

$(BUILDSCRIPT) $(LOADSCRIPT):
	$(ORACLE_HOME)/bin/sqlplus $(USERID) @$@ </dev/null

.pc.o:
	$(ORACLE_HOME)/bin/proc $(PROCPLSFLAGS) iname=$*.pc
	$(CC) $(CFLAGS) $(PRECOMPPUBLIC) -c $*.c

build: $(OBJS)
	$(CC) $(CFLAGS) -o $(EXE) $(OBJS) -L$(LIBHOME) $(DEMO_LIBS)

extproc.so:
	$(MAKE) -f $(EXTP_MAKEFILE) extproc_callback SHARED_LIBNAME=extproc.so OBJS="extproc.o"


$(PCDEMOS):  $(BUILDSCRIPT) $(LOADSCRIPT) 
	$(MAKE) -f $(DEMO_MAKEFILE) build EXE=$@ OBJS=$@.o

clean:
	$(RMF) pls_examp*.c pls_sample*.c *.o $(PCDEMOS)
